#!/usr/bin/env python
# -*- coding: utf-8 -*-
# https://pymodbustcp.readthedocs.io/en/latest/quickstart/index.html#
# read_bit
# read 10 bits and print result on stdout

from pyModbusTCP.client import ModbusClient
import time
import requests


s1 = "Teststring Input"

count = 0

url = 'http://www.bernhardt.de/modbus/sqlabfrage.php'

#datain = {'aktion':'write','file':'pyinputs.csv' ,'inhalt':'IN12345678' }
#datain = {'aktion':'write','file':'pyinputs.csv' ,'inhalt':count}
#dataout = {'aktion':'write','file':'pyoutputs.csv' ,'inhalt':'OUT12345678' }

#aktion=write&file=messwerte.csv&inhalt=Test




SERVER_HOST = "192.168.178.101"
SERVER_PORT = 502
SERVER_U_ID = 1

c = ModbusClient()

# uncomment this line to see debug message
#c.debug(True)

# define modbus server host, port and unit_id
c.host(SERVER_HOST)
c.port(SERVER_PORT)
c.unit_id(SERVER_U_ID)

while True:
    
    
    # open or reconnect TCP to modbus server
    if not c.is_open():
        if not c.open():
            print("unable to connect to "+SERVER_HOST+":"+str(SERVER_PORT))

    # if open() is ok, read coils (modbus function 0x01)
    if c.is_open():
        # read 8 bits at address 0, store result in regs list
        bits = c.read_coils(0, 8)
        # if success display registers
        if bits:
            print("Coils at #0 to 7: "+str(bits))
            s1 = str(bits)
        dataout = {'aktion':'write','file':'pyoutputs.csv' ,'inhalt': s1 }
        
        r = requests.post(url , dataout)
        print(r.text)
 
         # read 8 bits at address 0, store result in regs list
        bits = c.read_discrete_inputs(0, 8)
        # if success display registers
        if bits:
            print("Inputs ad #0 to 7: "+str(bits))   
            s1 = str(bits)
        datain = {'aktion':'write','file':'pyinputs.csv' ,'inhalt':s1}
 
        r = requests.post(url , datain)
        print(r.text)
 
 
        regs = c.read_holding_registers(0, 8)
        # if success display registers
        if regs:
            print("reg ad #0 to 7: "+str(regs))
 
     
        # sleep 0.5 s before next polling
        time.sleep(0.5)
